<div class="tab-pane fade  {{$route == 'web-backup'?'show active':''}}" id="web-backup" role="tabpanel"
    aria-labelledby="web-backup-tab">
    <div class="row p-0 m-0">
        <div class="col-md-12">
            <h4>@lang('setting.backup.history')</h4>
            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th>@lang('app.filename')</th>
                            <th>@lang('app.size')</th>
                            <th>@lang('app.time')</th>
                            <th>@lang('app.action')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(count($backups) > 0)
                        @foreach($backups as $backup)
                        <tr>
                            <td>{{$backup['filename']}}</td>
                            <td>{{ByteConverter::bytesToHuman($backup['size'])}}</td>
                            <td>{{date('Y-m-d H:i',$backup['time'])}}</td>
                            <td>
                                <div class="d-inline-block">
                                    <form
                                        action="{{route('admin.settings.backup.db',['name'=> $backup['filename'],'ext'=>$backup['extension']])}}"
                                        method="post">
                                        @csrf
                                        <button class="btn btn-info btn-sm"><i class="fa fa-download"></i></button>
                                    </form>
                                </div>
                                <div class="d-inline-block">
                                    <form
                                        action="{{route('admin.settings.backup.destroy',['name'=> $backup['filename'],'ext'=>$backup['extension']])}}"
                                        method="post">
                                        @csrf
                                        <button class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td></td>
                            <td></td>
                            <td><i>
                                    <h5>@lang('setting.no_record')</h5>
                                </i></td>
                            <td></td>
                            <td></td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <form action="{{route('admin.settings.backup.files')}}" method="POST">
                        @csrf
                        <input type="submit" class="w-100 mt-2 btn btn-success" value="@lang('setting.backup.file')">
                    </form>
                </div>
                <div class="col-md-6">
                    <form action="{{route('admin.settings.backup.db')}}" method="POST">
                        @csrf
                        <input type="submit" class="w-100 mt-2 btn btn-success"
                            value="@lang('setting.backup.database')">
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
